Option Explicit

Function GoOnline (ByVal ThePort As Integer) As Integer
  Dim I As Integer
  Dim Code As Integer
  'open the port
  Code = SioReset(ThePort, 1024, 1024)
  If Code < 0 Then
    Call SayError(SELFTEST, Code)
    GoOnline = 0
    Exit Function
  End If
  Code = SioBaud(ThePort, Baud38400)
  SELFTEST.Print "*** COM"; LTrim$(Str$(1 + ThePort)); " ready ";
  'set DTR & RTS
  Code = SioDTR(ThePort, Asc("S"))
  Code = SioRTS(ThePort, Asc("S"))
  ' set parms
  Code = SioParms(ThePort, NoParity, OneStopBit, WordLength8)
  Code = SioRxClear(ThePort)
  Code = SioTxClear(ThePort)
  GoOnline = 1
End Function

Sub ShowCaption ()
  Dim A As String
  Dim B As String
  A = "COM" + LTrim$(Str$(1 + The1stPort))
  B = "COM" + LTrim$(Str$(1 + The2ndPort))
  SELFTEST.Caption = "SelfTest: " + A + " ===> " + B
End Sub

Sub ShowConfig ()
  Dim Version As Integer
  Version = SioInfo(Asc("V"))
  SELFTEST.Print "*** SELFTEST 1.0"
  SELFTEST.Print "*** WSC Version ";
  SELFTEST.Print LTrim$(Str$(Version \ 16)) + ".";
  SELFTEST.Print LTrim$(Str$(Version Mod 16))
End Sub

Sub ShutDown ()
Dim Code As Integer
  Code = SioDone(The1stPort)
  Code = SioDone(The2ndPort)
End Sub
